// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.InformaticaDataManagement.Mocking;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.InformaticaDataManagement
{
    /// <summary> A class to add extension methods to Azure.ResourceManager.InformaticaDataManagement. </summary>
    public static partial class InformaticaDataManagementExtensions
    {
        private static MockableInformaticaDataManagementArmClient GetMockableInformaticaDataManagementArmClient(ArmClient client)
        {
            return client.GetCachedClient(client0 => new MockableInformaticaDataManagementArmClient(client0));
        }

        private static MockableInformaticaDataManagementResourceGroupResource GetMockableInformaticaDataManagementResourceGroupResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableInformaticaDataManagementResourceGroupResource(client, resource.Id));
        }

        private static MockableInformaticaDataManagementSubscriptionResource GetMockableInformaticaDataManagementSubscriptionResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableInformaticaDataManagementSubscriptionResource(client, resource.Id));
        }

        /// <summary>
        /// Gets an object representing an <see cref="InformaticaOrganizationResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="InformaticaOrganizationResource.CreateResourceIdentifier" /> to create an <see cref="InformaticaOrganizationResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementArmClient.GetInformaticaOrganizationResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="InformaticaOrganizationResource"/> object. </returns>
        public static InformaticaOrganizationResource GetInformaticaOrganizationResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableInformaticaDataManagementArmClient(client).GetInformaticaOrganizationResource(id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="InformaticaServerlessRuntimeResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="InformaticaServerlessRuntimeResource.CreateResourceIdentifier" /> to create an <see cref="InformaticaServerlessRuntimeResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementArmClient.GetInformaticaServerlessRuntimeResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="InformaticaServerlessRuntimeResource"/> object. </returns>
        public static InformaticaServerlessRuntimeResource GetInformaticaServerlessRuntimeResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableInformaticaDataManagementArmClient(client).GetInformaticaServerlessRuntimeResource(id);
        }

        /// <summary>
        /// Gets a collection of InformaticaOrganizationResources in the ResourceGroupResource.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementResourceGroupResource.GetInformaticaOrganizations()"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> is null. </exception>
        /// <returns> An object representing collection of InformaticaOrganizationResources and their operations over a InformaticaOrganizationResource. </returns>
        public static InformaticaOrganizationCollection GetInformaticaOrganizations(this ResourceGroupResource resourceGroupResource)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableInformaticaDataManagementResourceGroupResource(resourceGroupResource).GetInformaticaOrganizations();
        }

        /// <summary>
        /// Get a InformaticaOrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaOrganizationResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementResourceGroupResource.GetInformaticaOrganizationAsync(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<InformaticaOrganizationResource>> GetInformaticaOrganizationAsync(this ResourceGroupResource resourceGroupResource, string organizationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return await GetMockableInformaticaDataManagementResourceGroupResource(resourceGroupResource).GetInformaticaOrganizationAsync(organizationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a InformaticaOrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaOrganizationResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementResourceGroupResource.GetInformaticaOrganization(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<InformaticaOrganizationResource> GetInformaticaOrganization(this ResourceGroupResource resourceGroupResource, string organizationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableInformaticaDataManagementResourceGroupResource(resourceGroupResource).GetInformaticaOrganization(organizationName, cancellationToken);
        }

        /// <summary>
        /// List InformaticaOrganizationResource resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Informatica.DataManagement/organizations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaOrganizationResource_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementSubscriptionResource.GetInformaticaOrganizations(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> An async collection of <see cref="InformaticaOrganizationResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<InformaticaOrganizationResource> GetInformaticaOrganizationsAsync(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableInformaticaDataManagementSubscriptionResource(subscriptionResource).GetInformaticaOrganizationsAsync(cancellationToken);
        }

        /// <summary>
        /// List InformaticaOrganizationResource resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Informatica.DataManagement/organizations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaOrganizationResource_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableInformaticaDataManagementSubscriptionResource.GetInformaticaOrganizations(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> A collection of <see cref="InformaticaOrganizationResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<InformaticaOrganizationResource> GetInformaticaOrganizations(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableInformaticaDataManagementSubscriptionResource(subscriptionResource).GetInformaticaOrganizations(cancellationToken);
        }
    }
}
