// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmInformaticaDataManagementModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="InformaticaDataManagement.InformaticaServerlessRuntimeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="InformaticaDataManagement.InformaticaServerlessRuntimeData"/> instance for mocking. </returns>
        public static InformaticaServerlessRuntimeData InformaticaServerlessRuntimeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, InformaticaServerlessRuntimeProperties properties = null)
        {
            return new InformaticaServerlessRuntimeData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaServerlessRuntimeProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning State of the resource. </param>
        /// <param name="description"> description of the serverless runtime. </param>
        /// <param name="platform"> Platform type of the Serverless Runtime. </param>
        /// <param name="applicationType"> Application type of the Serverless Runtime environment. </param>
        /// <param name="computeUnits"> Compute units of the serverless runtime. </param>
        /// <param name="executionTimeout"> Serverless Execution timeout. </param>
        /// <param name="serverlessAccountLocation"> Serverless account creation location. </param>
        /// <param name="networkInterfaceConfiguration"> Informatica Serverless Network profile properties. </param>
        /// <param name="advancedCustomProperties"> String KV pairs indicating Advanced custom properties. </param>
        /// <param name="supplementaryFileLocation"> Supplementary file location. </param>
        /// <param name="serverlessRuntimeConfig"> Serverless config properties. </param>
        /// <param name="serverlessRuntimeTags"> Serverless Runtime Tags. </param>
        /// <param name="userContextToken"> Serverless runtime user context properties. </param>
        /// <returns> A new <see cref="Models.InformaticaServerlessRuntimeProperties"/> instance for mocking. </returns>
        public static InformaticaServerlessRuntimeProperties InformaticaServerlessRuntimeProperties(InformaticaProvisioningState? provisioningState = null, string description = null, InformaticaPlatformType? platform = null, InformaticaApplicationType? applicationType = null, string computeUnits = null, string executionTimeout = null, string serverlessAccountLocation = null, InformaticaNetworkInterfaceConfiguration networkInterfaceConfiguration = null, IEnumerable<AdvancedCustomProperties> advancedCustomProperties = null, string supplementaryFileLocation = null, ServerlessRuntimeConfigProperties serverlessRuntimeConfig = null, IEnumerable<ServerlessRuntimeTag> serverlessRuntimeTags = null, string userContextToken = null)
        {
            advancedCustomProperties ??= new List<AdvancedCustomProperties>();
            serverlessRuntimeTags ??= new List<ServerlessRuntimeTag>();

            return new InformaticaServerlessRuntimeProperties(
                provisioningState,
                description,
                platform,
                applicationType,
                computeUnits,
                executionTimeout,
                serverlessAccountLocation,
                networkInterfaceConfiguration != null ? new ServerlessRuntimeNetworkProfile(networkInterfaceConfiguration, serializedAdditionalRawData: null) : null,
                advancedCustomProperties?.ToList(),
                supplementaryFileLocation,
                serverlessRuntimeConfig,
                serverlessRuntimeTags?.ToList(),
                userContextToken != null ? new ServerlessRuntimeUserContextProperties(userContextToken, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckDependenciesResult"/>. </summary>
        /// <param name="count"> Count of dependencies. </param>
        /// <param name="id"> id of resource. </param>
        /// <param name="references"> List of dependencies. </param>
        /// <returns> A new <see cref="Models.CheckDependenciesResult"/> instance for mocking. </returns>
        public static CheckDependenciesResult CheckDependenciesResult(int count = default, string id = null, IEnumerable<ServerlessRuntimeDependency> references = null)
        {
            references ??= new List<ServerlessRuntimeDependency>();

            return new CheckDependenciesResult(count, id, references?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerlessRuntimeDependency"/>. </summary>
        /// <param name="id"> Dependency ID. </param>
        /// <param name="appContextId"> Application context ID. </param>
        /// <param name="path"> Dependency path. </param>
        /// <param name="documentType"> document type. </param>
        /// <param name="description"> description of Dependency. </param>
        /// <param name="lastUpdatedTime"> Last Update Time. </param>
        /// <returns> A new <see cref="Models.ServerlessRuntimeDependency"/> instance for mocking. </returns>
        public static ServerlessRuntimeDependency ServerlessRuntimeDependency(string id = null, string appContextId = null, string path = null, string documentType = null, string description = null, string lastUpdatedTime = null)
        {
            return new ServerlessRuntimeDependency(
                id,
                appContextId,
                path,
                documentType,
                description,
                lastUpdatedTime,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaDataManagement.InformaticaOrganizationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="InformaticaDataManagement.InformaticaOrganizationData"/> instance for mocking. </returns>
        public static InformaticaOrganizationData InformaticaOrganizationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, InformaticaOrganizationProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new InformaticaOrganizationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaOrganizationProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning State of the resource. </param>
        /// <param name="informaticaProperties"> Informatica Organization properties. </param>
        /// <param name="marketplaceDetails"> Marketplace details. </param>
        /// <param name="userDetails"> User details. </param>
        /// <param name="companyDetails"> Company details. </param>
        /// <param name="linkOrganizationToken"> Link Organization. </param>
        /// <returns> A new <see cref="Models.InformaticaOrganizationProperties"/> instance for mocking. </returns>
        public static InformaticaOrganizationProperties InformaticaOrganizationProperties(InformaticaProvisioningState? provisioningState = null, InformaticaProperties informaticaProperties = null, InformaticaMarketplaceDetails marketplaceDetails = null, InformaticaUserDetails userDetails = null, InformaticaCompanyDetails companyDetails = null, string linkOrganizationToken = null)
        {
            return new InformaticaOrganizationProperties(
                provisioningState,
                informaticaProperties,
                marketplaceDetails,
                userDetails,
                companyDetails,
                linkOrganizationToken != null ? new LinkOrganization(linkOrganizationToken, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerlessMetadataResponse"/>. </summary>
        /// <param name="runtimeType"> type of the runtime environment. </param>
        /// <param name="serverlessConfigProperties"> serverless config properties. </param>
        /// <param name="serverlessRuntimeConfigProperties"> serverless runtime config properties. </param>
        /// <returns> A new <see cref="Models.ServerlessMetadataResponse"/> instance for mocking. </returns>
        public static ServerlessMetadataResponse ServerlessMetadataResponse(InformaticaRuntimeType? runtimeType = null, ServerlessConfigProperties serverlessConfigProperties = null, ServerlessRuntimeConfigProperties serverlessRuntimeConfigProperties = null)
        {
            return new ServerlessMetadataResponse(runtimeType, serverlessConfigProperties, serverlessRuntimeConfigProperties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerlessConfigProperties"/>. </summary>
        /// <param name="platform"> Platform types. </param>
        /// <param name="applicationTypes"> List of application types supported by informatica. </param>
        /// <param name="computeUnits"> The list of compute units with possible array of values. </param>
        /// <param name="executionTimeout"> Serverless Runtime execution timeout. </param>
        /// <param name="regions"> List of supported serverless informatica regions. </param>
        /// <returns> A new <see cref="Models.ServerlessConfigProperties"/> instance for mocking. </returns>
        public static ServerlessConfigProperties ServerlessConfigProperties(InformaticaPlatformType? platform = null, IEnumerable<InformaticaApplicationTypeMetadata> applicationTypes = null, IEnumerable<ComputeUnitsMetadata> computeUnits = null, string executionTimeout = null, IEnumerable<InformaticaRegionsMetadata> regions = null)
        {
            applicationTypes ??= new List<InformaticaApplicationTypeMetadata>();
            computeUnits ??= new List<ComputeUnitsMetadata>();
            regions ??= new List<InformaticaRegionsMetadata>();

            return new ServerlessConfigProperties(
                platform,
                applicationTypes?.ToList(),
                computeUnits?.ToList(),
                executionTimeout,
                regions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaApplicationTypeMetadata"/>. </summary>
        /// <param name="name"> Application type name. </param>
        /// <param name="value"> Application type value. </param>
        /// <returns> A new <see cref="Models.InformaticaApplicationTypeMetadata"/> instance for mocking. </returns>
        public static InformaticaApplicationTypeMetadata InformaticaApplicationTypeMetadata(string name = null, string value = null)
        {
            return new InformaticaApplicationTypeMetadata(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComputeUnitsMetadata"/>. </summary>
        /// <param name="name"> ComputeUnit name. </param>
        /// <param name="value"> ComputeUnit value. </param>
        /// <returns> A new <see cref="Models.ComputeUnitsMetadata"/> instance for mocking. </returns>
        public static ComputeUnitsMetadata ComputeUnitsMetadata(string name = null, IEnumerable<string> value = null)
        {
            value ??= new List<string>();

            return new ComputeUnitsMetadata(name, value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaRegionsMetadata"/>. </summary>
        /// <param name="id"> Region Id. </param>
        /// <param name="name"> Region name. </param>
        /// <returns> A new <see cref="Models.InformaticaRegionsMetadata"/> instance for mocking. </returns>
        public static InformaticaRegionsMetadata InformaticaRegionsMetadata(string id = null, string name = null)
        {
            return new InformaticaRegionsMetadata(id, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaServerlessRuntimeResourceList"/>. </summary>
        /// <param name="informaticaRuntimeResources"> List of runtime resources for the fetch all API. </param>
        /// <returns> A new <see cref="Models.InformaticaServerlessRuntimeResourceList"/> instance for mocking. </returns>
        public static InformaticaServerlessRuntimeResourceList InformaticaServerlessRuntimeResourceList(IEnumerable<InformaticaRuntimeResourceFetchMetadata> informaticaRuntimeResources = null)
        {
            informaticaRuntimeResources ??= new List<InformaticaRuntimeResourceFetchMetadata>();

            return new InformaticaServerlessRuntimeResourceList(informaticaRuntimeResources?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaRuntimeResourceFetchMetadata"/>. </summary>
        /// <param name="name"> Environment name. </param>
        /// <param name="createdTime"> Created time. </param>
        /// <param name="updatedTime"> Updated Time. </param>
        /// <param name="createdBy"> Created by. </param>
        /// <param name="updatedBy"> Last Updated by. </param>
        /// <param name="id"> Informatica serverless runtime id. </param>
        /// <param name="runtimeType"> Environment Type. </param>
        /// <param name="status"> Status of the environment. </param>
        /// <param name="statusLocalized"> Display message for the given status. </param>
        /// <param name="statusMessage"> status message. </param>
        /// <param name="serverlessConfigProperties"> Serverless Config Properties. </param>
        /// <param name="description"> Description of the runtime resource. </param>
        /// <returns> A new <see cref="Models.InformaticaRuntimeResourceFetchMetadata"/> instance for mocking. </returns>
        public static InformaticaRuntimeResourceFetchMetadata InformaticaRuntimeResourceFetchMetadata(string name = null, string createdTime = null, string updatedTime = null, string createdBy = null, string updatedBy = null, string id = null, InformaticaRuntimeType runtimeType = default, string status = null, string statusLocalized = null, string statusMessage = null, InformaticaServerlessFetchConfigProperties serverlessConfigProperties = null, string description = null)
        {
            return new InformaticaRuntimeResourceFetchMetadata(
                name,
                createdTime,
                updatedTime,
                createdBy,
                updatedBy,
                id,
                runtimeType,
                status,
                statusLocalized,
                statusMessage,
                serverlessConfigProperties,
                description,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformaticaServerlessFetchConfigProperties"/>. </summary>
        /// <param name="subnet"> subnet name. </param>
        /// <param name="applicationType"> applicationType name. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="advancedCustomProperties"> Advanced custom properties. </param>
        /// <param name="supplementaryFileLocation"> Supplementary File location. </param>
        /// <param name="platform"> Serverless Account Platform. </param>
        /// <param name="tags"> Tags for the resource. </param>
        /// <param name="vnet"> virtual network. </param>
        /// <param name="executionTimeout"> Execution timeout. </param>
        /// <param name="computeUnits"> Compute Units. </param>
        /// <param name="tenantId"> Tenant ID. </param>
        /// <param name="subscriptionId"> subscription ID. </param>
        /// <param name="region"> region name for the runtime environment. </param>
        /// <param name="serverlessArmResourceId"> Serverless Arm Resource ID. </param>
        /// <returns> A new <see cref="Models.InformaticaServerlessFetchConfigProperties"/> instance for mocking. </returns>
        public static InformaticaServerlessFetchConfigProperties InformaticaServerlessFetchConfigProperties(string subnet = null, string applicationType = null, string resourceGroupName = null, string advancedCustomProperties = null, string supplementaryFileLocation = null, string platform = null, string tags = null, string vnet = null, string executionTimeout = null, string computeUnits = null, Guid? tenantId = null, string subscriptionId = null, string region = null, ResourceIdentifier serverlessArmResourceId = null)
        {
            return new InformaticaServerlessFetchConfigProperties(
                subnet,
                applicationType,
                resourceGroupName,
                advancedCustomProperties,
                supplementaryFileLocation,
                platform,
                tags,
                vnet,
                executionTimeout,
                computeUnits,
                tenantId,
                subscriptionId,
                region,
                serverlessArmResourceId,
                serializedAdditionalRawData: null);
        }
    }
}
