// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.InformaticaDataManagement.Models;

namespace Azure.ResourceManager.InformaticaDataManagement.Samples
{
    public partial class Sample_InformaticaServerlessRuntimeResource
    {
        // ServerlessRuntimes_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ServerlessRuntimesGet()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "InformaticaServerlessRuntimeResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "e3Y";
            string serverlessRuntimeName = "48-";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            InformaticaServerlessRuntimeResource result = await informaticaServerlessRuntime.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InformaticaServerlessRuntimeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ServerlessRuntimes_Get_Min
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ServerlessRuntimesGetMin()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "InformaticaServerlessRuntimeResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "YC";
            string serverlessRuntimeName = "___";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            InformaticaServerlessRuntimeResource result = await informaticaServerlessRuntime.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InformaticaServerlessRuntimeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ServerlessRuntimes_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ServerlessRuntimesDelete()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "InformaticaServerlessRuntimeResource_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "orgName";
            string serverlessRuntimeName = "serverlessRuntimeName";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            await informaticaServerlessRuntime.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ServerlessRuntimes_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ServerlessRuntimesUpdate()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_Update_MaximumSet_Gen.json
            // this example is just showing the usage of "InformaticaServerlessRuntimeResource_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "W5";
            string serverlessRuntimeName = "t_";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            InformaticaServerlessRuntimePatch patch = new InformaticaServerlessRuntimePatch()
            {
                Properties = new ServerlessRuntimePropertiesUpdate()
                {
                    Description = "ocprslpljoikxyduackzqnkuhyzrh",
                    Platform = InformaticaPlatformType.Azure,
                    ApplicationType = InformaticaApplicationType.Cdi,
                    ComputeUnits = "uncwbpu",
                    ExecutionTimeout = "tjyfytuywriabt",
                    ServerlessAccountLocation = "goaugkyfanqfnvcmntreibqrswfpis",
                    NetworkInterfaceConfiguration = new InformaticaNetworkInterfaceConfigurationUpdate()
                    {
                        VnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1"),
                        SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/subnet1"),
                        VnetResourceGuid = "5328d299-1462-4be0-bef1-303a28e556a0",
                    },
                    AdvancedCustomProperties =
{
new AdvancedCustomProperties()
{
Key = "qcmc",
Value = "unraxmnohdmvutt",
}
},
                    SupplementaryFileLocation = "csxaqzpxu",
                    ServerlessRuntimeConfig = new ServerlessRuntimeConfigPropertiesUpdate()
                    {
                        CdiConfigProps =
{
new CdiConfigProperties("hngsdqvtjdhwqlbqfotipaiwjuys","zlrlbg",new InformaticaApplicationConfigs[]
{
new InformaticaApplicationConfigs("lw","upfvjrqcrwwedfujkmsodeinw","mozgsetpwjmtyl","dixfyeobngivyvf","j","zvgkqwmi")
})
},
                        CdieConfigProps =
{
new CdiConfigProperties("hngsdqvtjdhwqlbqfotipaiwjuys","zlrlbg",new InformaticaApplicationConfigs[]
{
new InformaticaApplicationConfigs("lw","upfvjrqcrwwedfujkmsodeinw","mozgsetpwjmtyl","dixfyeobngivyvf","j","zvgkqwmi")
})
},
                    },
                    ServerlessRuntimeTags =
{
new ServerlessRuntimeTag()
{
Name = "korveuycuwhs",
Value = "uyiuegxnkgp",
}
},
                    UserContextToken = "ctgebtvjhwh",
                },
            };
            InformaticaServerlessRuntimeResource result = await informaticaServerlessRuntime.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InformaticaServerlessRuntimeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ServerlessRuntimes_Update_Min
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ServerlessRuntimesUpdateMin()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_Update_MinimumSet_Gen.json
            // this example is just showing the usage of "InformaticaServerlessRuntimeResource_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "_f--";
            string serverlessRuntimeName = "8Zr__";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            InformaticaServerlessRuntimePatch patch = new InformaticaServerlessRuntimePatch();
            InformaticaServerlessRuntimeResource result = await informaticaServerlessRuntime.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InformaticaServerlessRuntimeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ServerlessRuntimes_CheckDependencies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckDependencies_ServerlessRuntimesCheckDependencies()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_CheckDependencies_MaximumSet_Gen.json
            // this example is just showing the usage of "ServerlessRuntimes_CheckDependencies" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "3P";
            string serverlessRuntimeName = "M";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            CheckDependenciesResult result = await informaticaServerlessRuntime.CheckDependenciesAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ServerlessRuntimes_CheckDependencies_Min
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckDependencies_ServerlessRuntimesCheckDependenciesMin()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_CheckDependencies_MinimumSet_Gen.json
            // this example is just showing the usage of "ServerlessRuntimes_CheckDependencies" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "_-";
            string serverlessRuntimeName = "_2_";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            CheckDependenciesResult result = await informaticaServerlessRuntime.CheckDependenciesAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ServerlessRuntimes_StartFailedServerlessRuntime
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task StartFailedServerlessRuntime_ServerlessRuntimesStartFailedServerlessRuntime()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_StartFailedServerlessRuntime_MaximumSet_Gen.json
            // this example is just showing the usage of "ServerlessRuntimes_StartFailedServerlessRuntime" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "9M4";
            string serverlessRuntimeName = "-25-G_";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            await informaticaServerlessRuntime.StartFailedServerlessRuntimeAsync();

            Console.WriteLine($"Succeeded");
        }

        // ServerlessRuntimes_ServerlessResourceById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetServerlessResourceById_ServerlessRuntimesServerlessResourceById()
        {
            // Generated from example definition: 2024-05-08/ServerlessRuntimes_ServerlessResourceById_MaximumSet_Gen.json
            // this example is just showing the usage of "ServerlessRuntimes_GetServerlessResourceById" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InformaticaServerlessRuntimeResource created on azure
            // for more information of creating InformaticaServerlessRuntimeResource, please refer to the document of InformaticaServerlessRuntimeResource
            string subscriptionId = "3599DA28-E346-4D9F-811E-189C0445F0FE";
            string resourceGroupName = "rgopenapi";
            string organizationName = "_RD_R";
            string serverlessRuntimeName = "serverlessRuntimeName159";
            ResourceIdentifier informaticaServerlessRuntimeResourceId = InformaticaServerlessRuntimeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            InformaticaServerlessRuntimeResource informaticaServerlessRuntime = client.GetInformaticaServerlessRuntimeResource(informaticaServerlessRuntimeResourceId);

            // invoke the operation
            InformaticaServerlessRuntimeResource result = await informaticaServerlessRuntime.GetServerlessResourceByIdAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InformaticaServerlessRuntimeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
