﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System;
using System.IO;
using System.Threading.Tasks;
using Microsoft.Extensions.Azure;

#pragma warning disable CS8892 // Method 'UserAuthenticationSnippets.Main()' will not be used as an entry point because a synchronous entry point 'AutoGeneratedProgram.Main(string[])' was found.

namespace Azure.Identity.Samples
{
    public class TokenCacheSnippets
    {
        public void Identity_TokenCache_PersistentDefault()
        {
            #region Snippet:Identity_TokenCache_PersistentDefault
            var credential = new InteractiveBrowserCredential(
                new InteractiveBrowserCredentialOptions
                {
                    TokenCachePersistenceOptions = new TokenCachePersistenceOptions()
                });
            #endregion
        }

        public void Identity_TokenCache_PersistentNamed()
        {
            #region Snippet:Identity_TokenCache_PersistentNamed
            var persistenceOptions = new TokenCachePersistenceOptions { Name = "my_application_name" };

            var credential = new InteractiveBrowserCredential(
                new InteractiveBrowserCredentialOptions { TokenCachePersistenceOptions = persistenceOptions }
            );
            #endregion
        }

        public void Identity_TokenCache_PersistentUnencrypted()
        {
            #region Snippet:Identity_TokenCache_PersistentUnencrypted
            var persistenceOptions = new TokenCachePersistenceOptions { UnsafeAllowUnencryptedStorage = true };

            var credential = new InteractiveBrowserCredential(
                new InteractiveBrowserCredentialOptions { TokenCachePersistenceOptions = persistenceOptions }
            );
            #endregion
        }
//TODO: Move these samples and refactor for new UnsafeTokenCacheOptions
/*
        public async Task Identity_TokenCache_CustomPersistence_Read()
        {
            #region Snippet:Identity_TokenCache_CustomPersistence_Read
            await Task.Yield();
            TokenCachePersistenceOptions tokenCache;

            using (var cacheStream = new FileStream(TOKEN_CACHE_PATH, FileMode.OpenOrCreate, FileAccess.Read))
            {
                tokenCache = await TokenCacheSerializer.DeserializeAsync(cacheStream);
            }
            #endregion
        }

        public async Task Identity_TokenCache_CustomPersistence_Write()
        {
            var persistenceOptions = new TokenCachePersistenceOptions();
            await Task.Yield();

            #region Snippet:Identity_TokenCache_CustomPersistence_Write
            using (var cacheStream = new FileStream(TOKEN_CACHE_PATH, FileMode.Create, FileAccess.Write))
            {
                await TokenCacheSerializer.SerializeAsync(tokenCache, cacheStream);
            }
            #endregion
        }

        #region Snippet:Identity_TokenCache_CustomPersistence_Usage
        public static async Task<TokenCacheOptions> ReadTokenCacheAsync()
        {
            TokenCacheOptions tokenCache;

            using (var cacheStream = new FileStream(TOKEN_CACHE_PATH, FileMode.OpenOrCreate, FileAccess.Read))
            {
                tokenCache = await TokenCacheSerializer.DeserializeAsync(cacheStream);
                tokenCache.Updated += WriteCacheOnUpdateAsync;
            }

            return tokenCache;
        }

        public static async Task WriteCacheOnUpdateAsync(TokenCacheUpdatedArgs args)
        {
            using (var cacheStream = new FileStream(TOKEN_CACHE_PATH, FileMode.Create, FileAccess.Write))
            {
                await TokenCacheSerializer.SerializeAsync(args.Cache, cacheStream);
            }
        }

        public static async Task Main()
        {
            var persistenceOptions = await ReadTokenCacheAsync();

            var credential = new InteractiveBrowserCredential(
                new InteractiveBrowserCredentialOptions { TokenCacheOptions = tokenCache }
            );
        }
        #endregion
        */
    }
}
