// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.HybridNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="SiteNetworkServiceResource"/> and their operations.
    /// Each <see cref="SiteNetworkServiceResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="SiteNetworkServiceCollection"/> instance call the GetSiteNetworkServices method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class SiteNetworkServiceCollection : ArmCollection, IEnumerable<SiteNetworkServiceResource>, IAsyncEnumerable<SiteNetworkServiceResource>
    {
        private readonly ClientDiagnostics _siteNetworkServiceClientDiagnostics;
        private readonly SiteNetworkServicesRestOperations _siteNetworkServiceRestClient;

        /// <summary> Initializes a new instance of the <see cref="SiteNetworkServiceCollection"/> class for mocking. </summary>
        protected SiteNetworkServiceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SiteNetworkServiceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SiteNetworkServiceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _siteNetworkServiceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.HybridNetwork", SiteNetworkServiceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SiteNetworkServiceResource.ResourceType, out string siteNetworkServiceApiVersion);
            _siteNetworkServiceRestClient = new SiteNetworkServicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, siteNetworkServiceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a network site.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="data"> Parameters supplied to the create or update site network service operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SiteNetworkServiceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string siteNetworkServiceName, SiteNetworkServiceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _siteNetworkServiceRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, data, cancellationToken).ConfigureAwait(false);
                var operation = new HybridNetworkArmOperation<SiteNetworkServiceResource>(new SiteNetworkServiceOperationSource(Client), _siteNetworkServiceClientDiagnostics, Pipeline, _siteNetworkServiceRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a network site.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="data"> Parameters supplied to the create or update site network service operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SiteNetworkServiceResource> CreateOrUpdate(WaitUntil waitUntil, string siteNetworkServiceName, SiteNetworkServiceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _siteNetworkServiceRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, data, cancellationToken);
                var operation = new HybridNetworkArmOperation<SiteNetworkServiceResource>(new SiteNetworkServiceOperationSource(Client), _siteNetworkServiceClientDiagnostics, Pipeline, _siteNetworkServiceRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified site network service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> is null. </exception>
        public virtual async Task<Response<SiteNetworkServiceResource>> GetAsync(string siteNetworkServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.Get");
            scope.Start();
            try
            {
                var response = await _siteNetworkServiceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SiteNetworkServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified site network service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> is null. </exception>
        public virtual Response<SiteNetworkServiceResource> Get(string siteNetworkServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.Get");
            scope.Start();
            try
            {
                var response = _siteNetworkServiceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SiteNetworkServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all site network services.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SiteNetworkServiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SiteNetworkServiceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _siteNetworkServiceRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _siteNetworkServiceRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SiteNetworkServiceResource(Client, SiteNetworkServiceData.DeserializeSiteNetworkServiceData(e)), _siteNetworkServiceClientDiagnostics, Pipeline, "SiteNetworkServiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all site network services.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SiteNetworkServiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SiteNetworkServiceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _siteNetworkServiceRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _siteNetworkServiceRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SiteNetworkServiceResource(Client, SiteNetworkServiceData.DeserializeSiteNetworkServiceData(e)), _siteNetworkServiceClientDiagnostics, Pipeline, "SiteNetworkServiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string siteNetworkServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _siteNetworkServiceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> is null. </exception>
        public virtual Response<bool> Exists(string siteNetworkServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.Exists");
            scope.Start();
            try
            {
                var response = _siteNetworkServiceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SiteNetworkServiceResource>> GetIfExistsAsync(string siteNetworkServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _siteNetworkServiceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SiteNetworkServiceResource>(response.GetRawResponse());
                return Response.FromValue(new SiteNetworkServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SiteNetworkServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SiteNetworkServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteNetworkServiceName"> The name of the site network service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteNetworkServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteNetworkServiceName"/> is null. </exception>
        public virtual NullableResponse<SiteNetworkServiceResource> GetIfExists(string siteNetworkServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteNetworkServiceName, nameof(siteNetworkServiceName));

            using var scope = _siteNetworkServiceClientDiagnostics.CreateScope("SiteNetworkServiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _siteNetworkServiceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, siteNetworkServiceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SiteNetworkServiceResource>(response.GetRawResponse());
                return Response.FromValue(new SiteNetworkServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SiteNetworkServiceResource> IEnumerable<SiteNetworkServiceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SiteNetworkServiceResource> IAsyncEnumerable<SiteNetworkServiceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
