// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Site network service properties. </summary>
    public partial class SiteNetworkServicePropertiesFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteNetworkServicePropertiesFormat"/>. </summary>
        public SiteNetworkServicePropertiesFormat()
        {
            DesiredStateConfigurationGroupValueReferences = new ChangeTrackingDictionary<string, WritableSubResource>();
            LastStateConfigurationGroupValueReferences = new ChangeTrackingDictionary<string, WritableSubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteNetworkServicePropertiesFormat"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the site network service resource. </param>
        /// <param name="managedResourceGroupConfiguration"> Managed resource group configuration. </param>
        /// <param name="siteReference"> The site details. </param>
        /// <param name="publisherName"> The publisher name for the site network service. </param>
        /// <param name="publisherScope"> The scope of the publisher. </param>
        /// <param name="networkServiceDesignGroupName"> The network service design group name for the site network service. </param>
        /// <param name="networkServiceDesignVersionName"> The network service design version for the site network service. </param>
        /// <param name="networkServiceDesignVersionOfferingLocation"> The location of the network service design offering. </param>
        /// <param name="networkServiceDesignVersionResourceReference">
        /// The network service design version resource reference.
        /// Please note <see cref="DeploymentResourceIdReference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="OpenDeploymentResourceReference"/> and <see cref="SecretDeploymentResourceReference"/>.
        /// </param>
        /// <param name="desiredStateConfigurationGroupValueReferences"> The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service. </param>
        /// <param name="lastStateNetworkServiceDesignVersionName"> The network service design version for the site network service. </param>
        /// <param name="lastStateConfigurationGroupValueReferences"> The last state of the site network service resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteNetworkServicePropertiesFormat(ProvisioningState? provisioningState, ManagedResourceGroupConfiguration managedResourceGroupConfiguration, WritableSubResource siteReference, string publisherName, PublisherScope? publisherScope, string networkServiceDesignGroupName, string networkServiceDesignVersionName, string networkServiceDesignVersionOfferingLocation, DeploymentResourceIdReference networkServiceDesignVersionResourceReference, IDictionary<string, WritableSubResource> desiredStateConfigurationGroupValueReferences, string lastStateNetworkServiceDesignVersionName, IReadOnlyDictionary<string, WritableSubResource> lastStateConfigurationGroupValueReferences, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            ManagedResourceGroupConfiguration = managedResourceGroupConfiguration;
            SiteReference = siteReference;
            PublisherName = publisherName;
            PublisherScope = publisherScope;
            NetworkServiceDesignGroupName = networkServiceDesignGroupName;
            NetworkServiceDesignVersionName = networkServiceDesignVersionName;
            NetworkServiceDesignVersionOfferingLocation = networkServiceDesignVersionOfferingLocation;
            NetworkServiceDesignVersionResourceReference = networkServiceDesignVersionResourceReference;
            DesiredStateConfigurationGroupValueReferences = desiredStateConfigurationGroupValueReferences;
            LastStateNetworkServiceDesignVersionName = lastStateNetworkServiceDesignVersionName;
            LastStateConfigurationGroupValueReferences = lastStateConfigurationGroupValueReferences;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the site network service resource. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> Managed resource group configuration. </summary>
        public ManagedResourceGroupConfiguration ManagedResourceGroupConfiguration { get; set; }
        /// <summary> The site details. </summary>
        internal WritableSubResource SiteReference { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier SiteReferenceId
        {
            get => SiteReference is null ? default : SiteReference.Id;
            set
            {
                if (SiteReference is null)
                    SiteReference = new WritableSubResource();
                SiteReference.Id = value;
            }
        }

        /// <summary> The publisher name for the site network service. </summary>
        public string PublisherName { get; }
        /// <summary> The scope of the publisher. </summary>
        public PublisherScope? PublisherScope { get; }
        /// <summary> The network service design group name for the site network service. </summary>
        public string NetworkServiceDesignGroupName { get; }
        /// <summary> The network service design version for the site network service. </summary>
        public string NetworkServiceDesignVersionName { get; }
        /// <summary> The location of the network service design offering. </summary>
        public string NetworkServiceDesignVersionOfferingLocation { get; }
        /// <summary>
        /// The network service design version resource reference.
        /// Please note <see cref="DeploymentResourceIdReference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="OpenDeploymentResourceReference"/> and <see cref="SecretDeploymentResourceReference"/>.
        /// </summary>
        public DeploymentResourceIdReference NetworkServiceDesignVersionResourceReference { get; set; }
        /// <summary> The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service. </summary>
        public IDictionary<string, WritableSubResource> DesiredStateConfigurationGroupValueReferences { get; }
        /// <summary> The network service design version for the site network service. </summary>
        public string LastStateNetworkServiceDesignVersionName { get; }
        /// <summary> The last state of the site network service resource. </summary>
        public IReadOnlyDictionary<string, WritableSubResource> LastStateConfigurationGroupValueReferences { get; }
    }
}
