// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Secret deployment resource id reference. </summary>
    public partial class SecretDeploymentResourceReference : DeploymentResourceIdReference
    {
        /// <summary> Initializes a new instance of <see cref="SecretDeploymentResourceReference"/>. </summary>
        public SecretDeploymentResourceReference()
        {
            IdType = IdType.Secret;
        }

        /// <summary> Initializes a new instance of <see cref="SecretDeploymentResourceReference"/>. </summary>
        /// <param name="idType"> The resource reference arm id type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="id"> Resource ID. </param>
        internal SecretDeploymentResourceReference(IdType idType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier id) : base(idType, serializedAdditionalRawData)
        {
            Id = id;
            IdType = idType;
        }

        /// <summary> Resource ID. </summary>
        public ResourceIdentifier Id { get; set; }
    }
}
