// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Publisher Scope. </summary>
    public readonly partial struct PublisherScope : IEquatable<PublisherScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PublisherScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PublisherScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PrivateValue = "Private";

        /// <summary> Unknown. </summary>
        public static PublisherScope Unknown { get; } = new PublisherScope(UnknownValue);
        /// <summary> Private. </summary>
        public static PublisherScope Private { get; } = new PublisherScope(PrivateValue);
        /// <summary> Determines if two <see cref="PublisherScope"/> values are the same. </summary>
        public static bool operator ==(PublisherScope left, PublisherScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PublisherScope"/> values are not the same. </summary>
        public static bool operator !=(PublisherScope left, PublisherScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PublisherScope"/>. </summary>
        public static implicit operator PublisherScope(string value) => new PublisherScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PublisherScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PublisherScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
