// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The status of a Pod. </summary>
    public readonly partial struct PodStatus : IEquatable<PodStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PodStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PodStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string RunningValue = "Running";
        private const string PendingValue = "Pending";
        private const string TerminatingValue = "Terminating";
        private const string NotReadyValue = "NotReady";

        /// <summary> Unknown. </summary>
        public static PodStatus Unknown { get; } = new PodStatus(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static PodStatus Succeeded { get; } = new PodStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static PodStatus Failed { get; } = new PodStatus(FailedValue);
        /// <summary> Running. </summary>
        public static PodStatus Running { get; } = new PodStatus(RunningValue);
        /// <summary> Pending. </summary>
        public static PodStatus Pending { get; } = new PodStatus(PendingValue);
        /// <summary> Terminating. </summary>
        public static PodStatus Terminating { get; } = new PodStatus(TerminatingValue);
        /// <summary> NotReady. </summary>
        public static PodStatus NotReady { get; } = new PodStatus(NotReadyValue);
        /// <summary> Determines if two <see cref="PodStatus"/> values are the same. </summary>
        public static bool operator ==(PodStatus left, PodStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PodStatus"/> values are not the same. </summary>
        public static bool operator !=(PodStatus left, PodStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PodStatus"/>. </summary>
        public static implicit operator PodStatus(string value) => new PodStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PodStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PodStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
