// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Pod Event  properties. </summary>
    public partial class PodEvent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PodEvent"/>. </summary>
        internal PodEvent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PodEvent"/>. </summary>
        /// <param name="eventType"> The type of pod event. </param>
        /// <param name="reason"> Event reason. </param>
        /// <param name="message"> Event message. </param>
        /// <param name="lastSeenOn"> Event Last seen. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PodEvent(PodEventType? eventType, string reason, string message, DateTimeOffset? lastSeenOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EventType = eventType;
            Reason = reason;
            Message = message;
            LastSeenOn = lastSeenOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of pod event. </summary>
        public PodEventType? EventType { get; }
        /// <summary> Event reason. </summary>
        public string Reason { get; }
        /// <summary> Event message. </summary>
        public string Message { get; }
        /// <summary> Event Last seen. </summary>
        public DateTimeOffset? LastSeenOn { get; }
    }
}
