// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The NFVI type. </summary>
    public readonly partial struct NfviType : IEquatable<NfviType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NfviType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NfviType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string AzureArcKubernetesValue = "AzureArcKubernetes";
        private const string AzureCoreValue = "AzureCore";
        private const string AzureOperatorNexusValue = "AzureOperatorNexus";

        /// <summary> Unknown. </summary>
        public static NfviType Unknown { get; } = new NfviType(UnknownValue);
        /// <summary> AzureArcKubernetes. </summary>
        public static NfviType AzureArcKubernetes { get; } = new NfviType(AzureArcKubernetesValue);
        /// <summary> AzureCore. </summary>
        public static NfviType AzureCore { get; } = new NfviType(AzureCoreValue);
        /// <summary> AzureOperatorNexus. </summary>
        public static NfviType AzureOperatorNexus { get; } = new NfviType(AzureOperatorNexusValue);
        /// <summary> Determines if two <see cref="NfviType"/> values are the same. </summary>
        public static bool operator ==(NfviType left, NfviType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NfviType"/> values are not the same. </summary>
        public static bool operator !=(NfviType left, NfviType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NfviType"/>. </summary>
        public static implicit operator NfviType(string value) => new NfviType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NfviType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NfviType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
