// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary>
    /// Network function definition version properties.
    /// Please note <see cref="NetworkFunctionDefinitionVersionPropertiesFormat"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ContainerizedNetworkFunctionDefinitionVersion"/> and <see cref="VirtualNetworkFunctionDefinitionVersion"/>.
    /// </summary>
    public abstract partial class NetworkFunctionDefinitionVersionPropertiesFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkFunctionDefinitionVersionPropertiesFormat"/>. </summary>
        protected NetworkFunctionDefinitionVersionPropertiesFormat()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFunctionDefinitionVersionPropertiesFormat"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the network function definition version resource. </param>
        /// <param name="versionState"> The network function definition version state. </param>
        /// <param name="description"> The network function definition version description. </param>
        /// <param name="deployParameters"> The deployment parameters of the network function definition version. </param>
        /// <param name="networkFunctionType"> The network function type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkFunctionDefinitionVersionPropertiesFormat(ProvisioningState? provisioningState, VersionState? versionState, string description, string deployParameters, NetworkFunctionType networkFunctionType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            VersionState = versionState;
            Description = description;
            DeployParameters = deployParameters;
            NetworkFunctionType = networkFunctionType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the network function definition version resource. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> The network function definition version state. </summary>
        public VersionState? VersionState { get; }
        /// <summary> The network function definition version description. </summary>
        public string Description { get; set; }
        /// <summary> The deployment parameters of the network function definition version. </summary>
        public string DeployParameters { get; set; }
        /// <summary> The network function type. </summary>
        internal NetworkFunctionType NetworkFunctionType { get; set; }
    }
}
