// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The secret type which indicates if secret or not. </summary>
    internal readonly partial struct NetworkFunctionConfigurationType : IEquatable<NetworkFunctionConfigurationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkFunctionConfigurationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkFunctionConfigurationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SecretValue = "Secret";
        private const string OpenValue = "Open";

        /// <summary> Unknown. </summary>
        public static NetworkFunctionConfigurationType Unknown { get; } = new NetworkFunctionConfigurationType(UnknownValue);
        /// <summary> Secret. </summary>
        public static NetworkFunctionConfigurationType Secret { get; } = new NetworkFunctionConfigurationType(SecretValue);
        /// <summary> Open. </summary>
        public static NetworkFunctionConfigurationType Open { get; } = new NetworkFunctionConfigurationType(OpenValue);
        /// <summary> Determines if two <see cref="NetworkFunctionConfigurationType"/> values are the same. </summary>
        public static bool operator ==(NetworkFunctionConfigurationType left, NetworkFunctionConfigurationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkFunctionConfigurationType"/> values are not the same. </summary>
        public static bool operator !=(NetworkFunctionConfigurationType left, NetworkFunctionConfigurationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkFunctionConfigurationType"/>. </summary>
        public static implicit operator NetworkFunctionConfigurationType(string value) => new NetworkFunctionConfigurationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkFunctionConfigurationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkFunctionConfigurationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
