// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    public partial class ManifestArtifactFormat : IUtf8JsonSerializable, IJsonModel<ManifestArtifactFormat>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ManifestArtifactFormat>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ManifestArtifactFormat>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManifestArtifactFormat>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManifestArtifactFormat)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ArtifactName))
            {
                writer.WritePropertyName("artifactName"u8);
                writer.WriteStringValue(ArtifactName);
            }
            if (Optional.IsDefined(ArtifactType))
            {
                writer.WritePropertyName("artifactType"u8);
                writer.WriteStringValue(ArtifactType.Value.ToString());
            }
            if (Optional.IsDefined(ArtifactVersion))
            {
                writer.WritePropertyName("artifactVersion"u8);
                writer.WriteStringValue(ArtifactVersion);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ManifestArtifactFormat IJsonModel<ManifestArtifactFormat>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManifestArtifactFormat>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManifestArtifactFormat)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeManifestArtifactFormat(document.RootElement, options);
        }

        internal static ManifestArtifactFormat DeserializeManifestArtifactFormat(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string artifactName = default;
            ArtifactType? artifactType = default;
            string artifactVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("artifactName"u8))
                {
                    artifactName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("artifactType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    artifactType = new ArtifactType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("artifactVersion"u8))
                {
                    artifactVersion = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ManifestArtifactFormat(artifactName, artifactType, artifactVersion, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ManifestArtifactFormat>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManifestArtifactFormat>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ManifestArtifactFormat)} does not support writing '{options.Format}' format.");
            }
        }

        ManifestArtifactFormat IPersistableModel<ManifestArtifactFormat>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManifestArtifactFormat>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeManifestArtifactFormat(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ManifestArtifactFormat)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ManifestArtifactFormat>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
