// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Helm StatefulSet status properties. </summary>
    public partial class KubernetesStatefulSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KubernetesStatefulSet"/>. </summary>
        internal KubernetesStatefulSet()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KubernetesStatefulSet"/>. </summary>
        /// <param name="name"> The name of the statefulset. </param>
        /// <param name="namespace"> The namespace of the statefulset. </param>
        /// <param name="desiredNumberOfPods"> Desired number of pods. </param>
        /// <param name="readyNumberOfPods"> Number of ready pods. </param>
        /// <param name="createdOn"> Creation Time of statefulset. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KubernetesStatefulSet(string name, string @namespace, int? desiredNumberOfPods, int? readyNumberOfPods, DateTimeOffset? createdOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Namespace = @namespace;
            DesiredNumberOfPods = desiredNumberOfPods;
            ReadyNumberOfPods = readyNumberOfPods;
            CreatedOn = createdOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the statefulset. </summary>
        public string Name { get; }
        /// <summary> The namespace of the statefulset. </summary>
        public string Namespace { get; }
        /// <summary> Desired number of pods. </summary>
        public int? DesiredNumberOfPods { get; }
        /// <summary> Number of ready pods. </summary>
        public int? ReadyNumberOfPods { get; }
        /// <summary> Creation Time of statefulset. </summary>
        public DateTimeOffset? CreatedOn { get; }
    }
}
