// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Helm Deployment status properties. </summary>
    public partial class KubernetesDeployment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KubernetesDeployment"/>. </summary>
        internal KubernetesDeployment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KubernetesDeployment"/>. </summary>
        /// <param name="name"> The name of the deployment. </param>
        /// <param name="namespace"> The namespace of the deployment. </param>
        /// <param name="desiredNumberOfPods"> Desired number of pods. </param>
        /// <param name="readyNumberOfPods"> Number of ready pods. </param>
        /// <param name="upToDateNumberOfPods"> Number of upto date pods. </param>
        /// <param name="availableNumberOfPods"> Number of available pods. </param>
        /// <param name="createdOn"> Creation Time of deployment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KubernetesDeployment(string name, string @namespace, int? desiredNumberOfPods, int? readyNumberOfPods, int? upToDateNumberOfPods, int? availableNumberOfPods, DateTimeOffset? createdOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Namespace = @namespace;
            DesiredNumberOfPods = desiredNumberOfPods;
            ReadyNumberOfPods = readyNumberOfPods;
            UpToDateNumberOfPods = upToDateNumberOfPods;
            AvailableNumberOfPods = availableNumberOfPods;
            CreatedOn = createdOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the deployment. </summary>
        public string Name { get; }
        /// <summary> The namespace of the deployment. </summary>
        public string Namespace { get; }
        /// <summary> Desired number of pods. </summary>
        public int? DesiredNumberOfPods { get; }
        /// <summary> Number of ready pods. </summary>
        public int? ReadyNumberOfPods { get; }
        /// <summary> Number of upto date pods. </summary>
        public int? UpToDateNumberOfPods { get; }
        /// <summary> Number of available pods. </summary>
        public int? AvailableNumberOfPods { get; }
        /// <summary> Creation Time of deployment. </summary>
        public DateTimeOffset? CreatedOn { get; }
    }
}
