// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The resource reference arm id type. </summary>
    internal readonly partial struct IdType : IEquatable<IdType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IdType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IdType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string OpenValue = "Open";
        private const string SecretValue = "Secret";

        /// <summary> Unknown. </summary>
        public static IdType Unknown { get; } = new IdType(UnknownValue);
        /// <summary> Open. </summary>
        public static IdType Open { get; } = new IdType(OpenValue);
        /// <summary> Secret. </summary>
        public static IdType Secret { get; } = new IdType(SecretValue);
        /// <summary> Determines if two <see cref="IdType"/> values are the same. </summary>
        public static bool operator ==(IdType left, IdType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IdType"/> values are not the same. </summary>
        public static bool operator !=(IdType left, IdType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IdType"/>. </summary>
        public static implicit operator IdType(string value) => new IdType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IdType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IdType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
