// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The SKU tier based on the SKU name. </summary>
    public readonly partial struct HybridNetworkSkuTier : IEquatable<HybridNetworkSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridNetworkSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridNetworkSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> Basic. </summary>
        public static HybridNetworkSkuTier Basic { get; } = new HybridNetworkSkuTier(BasicValue);
        /// <summary> Standard. </summary>
        public static HybridNetworkSkuTier Standard { get; } = new HybridNetworkSkuTier(StandardValue);
        /// <summary> Determines if two <see cref="HybridNetworkSkuTier"/> values are the same. </summary>
        public static bool operator ==(HybridNetworkSkuTier left, HybridNetworkSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridNetworkSkuTier"/> values are not the same. </summary>
        public static bool operator !=(HybridNetworkSkuTier left, HybridNetworkSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridNetworkSkuTier"/>. </summary>
        public static implicit operator HybridNetworkSkuTier(string value) => new HybridNetworkSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridNetworkSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridNetworkSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
