// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Name of this Sku. </summary>
    public readonly partial struct HybridNetworkSkuName : IEquatable<HybridNetworkSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridNetworkSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridNetworkSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> Basic. </summary>
        public static HybridNetworkSkuName Basic { get; } = new HybridNetworkSkuName(BasicValue);
        /// <summary> Standard. </summary>
        public static HybridNetworkSkuName Standard { get; } = new HybridNetworkSkuName(StandardValue);
        /// <summary> Determines if two <see cref="HybridNetworkSkuName"/> values are the same. </summary>
        public static bool operator ==(HybridNetworkSkuName left, HybridNetworkSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridNetworkSkuName"/> values are not the same. </summary>
        public static bool operator !=(HybridNetworkSkuName left, HybridNetworkSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridNetworkSkuName"/>. </summary>
        public static implicit operator HybridNetworkSkuName(string value) => new HybridNetworkSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridNetworkSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridNetworkSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
