// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    public partial class HelmUpgradeConfig : IUtf8JsonSerializable, IJsonModel<HelmUpgradeConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HelmUpgradeConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HelmUpgradeConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HelmUpgradeConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HelmUpgradeConfig)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Atomic))
            {
                writer.WritePropertyName("atomic"u8);
                writer.WriteStringValue(Atomic);
            }
            if (Optional.IsDefined(Wait))
            {
                writer.WritePropertyName("wait"u8);
                writer.WriteStringValue(Wait);
            }
            if (Optional.IsDefined(Timeout))
            {
                writer.WritePropertyName("timeout"u8);
                writer.WriteStringValue(Timeout);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HelmUpgradeConfig IJsonModel<HelmUpgradeConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HelmUpgradeConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HelmUpgradeConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHelmUpgradeConfig(document.RootElement, options);
        }

        internal static HelmUpgradeConfig DeserializeHelmUpgradeConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string atomic = default;
            string wait = default;
            string timeout = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("atomic"u8))
                {
                    atomic = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("wait"u8))
                {
                    wait = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timeout"u8))
                {
                    timeout = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HelmUpgradeConfig(atomic, wait, timeout, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HelmUpgradeConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HelmUpgradeConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HelmUpgradeConfig)} does not support writing '{options.Format}' format.");
            }
        }

        HelmUpgradeConfig IPersistableModel<HelmUpgradeConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HelmUpgradeConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHelmUpgradeConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HelmUpgradeConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HelmUpgradeConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
