// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The helm deployment options. </summary>
    public partial class HelmMappingRuleProfileConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HelmMappingRuleProfileConfig"/>. </summary>
        public HelmMappingRuleProfileConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HelmMappingRuleProfileConfig"/>. </summary>
        /// <param name="installOptions"> The helm deployment install options. </param>
        /// <param name="upgradeOptions"> The helm deployment upgrade options. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HelmMappingRuleProfileConfig(HelmInstallConfig installOptions, HelmUpgradeConfig upgradeOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InstallOptions = installOptions;
            UpgradeOptions = upgradeOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The helm deployment install options. </summary>
        public HelmInstallConfig InstallOptions { get; set; }
        /// <summary> The helm deployment upgrade options. </summary>
        public HelmUpgradeConfig UpgradeOptions { get; set; }
    }
}
