// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Helm artifact profile. </summary>
    public partial class HelmArtifactProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HelmArtifactProfile"/>. </summary>
        public HelmArtifactProfile()
        {
            RegistryValuesPaths = new ChangeTrackingList<string>();
            ImagePullSecretsValuesPaths = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HelmArtifactProfile"/>. </summary>
        /// <param name="helmPackageName"> Helm package name. </param>
        /// <param name="helmPackageVersionRange"> Helm package version range. </param>
        /// <param name="registryValuesPaths"> The registry values path list. </param>
        /// <param name="imagePullSecretsValuesPaths"> The image pull secrets values path list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HelmArtifactProfile(string helmPackageName, string helmPackageVersionRange, IList<string> registryValuesPaths, IList<string> imagePullSecretsValuesPaths, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HelmPackageName = helmPackageName;
            HelmPackageVersionRange = helmPackageVersionRange;
            RegistryValuesPaths = registryValuesPaths;
            ImagePullSecretsValuesPaths = imagePullSecretsValuesPaths;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Helm package name. </summary>
        public string HelmPackageName { get; set; }
        /// <summary> Helm package version range. </summary>
        public string HelmPackageVersionRange { get; set; }
        /// <summary> The registry values path list. </summary>
        public IList<string> RegistryValuesPaths { get; }
        /// <summary> The image pull secrets values path list. </summary>
        public IList<string> ImagePullSecretsValuesPaths { get; }
    }
}
