// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Payload for execute request post call. </summary>
    public partial class ExecuteRequestContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExecuteRequestContent"/>. </summary>
        /// <param name="serviceEndpoint"> The endpoint of service to call. </param>
        /// <param name="requestMetadata"> The request metadata. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceEndpoint"/> or <paramref name="requestMetadata"/> is null. </exception>
        public ExecuteRequestContent(string serviceEndpoint, RequestMetadata requestMetadata)
        {
            Argument.AssertNotNull(serviceEndpoint, nameof(serviceEndpoint));
            Argument.AssertNotNull(requestMetadata, nameof(requestMetadata));

            ServiceEndpoint = serviceEndpoint;
            RequestMetadata = requestMetadata;
        }

        /// <summary> Initializes a new instance of <see cref="ExecuteRequestContent"/>. </summary>
        /// <param name="serviceEndpoint"> The endpoint of service to call. </param>
        /// <param name="requestMetadata"> The request metadata. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExecuteRequestContent(string serviceEndpoint, RequestMetadata requestMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceEndpoint = serviceEndpoint;
            RequestMetadata = requestMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExecuteRequestContent"/> for deserialization. </summary>
        internal ExecuteRequestContent()
        {
        }

        /// <summary> The endpoint of service to call. </summary>
        public string ServiceEndpoint { get; }
        /// <summary> The request metadata. </summary>
        public RequestMetadata RequestMetadata { get; }
    }
}
