// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    public partial class ExecuteRequestContent : IUtf8JsonSerializable, IJsonModel<ExecuteRequestContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExecuteRequestContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExecuteRequestContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecuteRequestContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExecuteRequestContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("serviceEndpoint"u8);
            writer.WriteStringValue(ServiceEndpoint);
            writer.WritePropertyName("requestMetadata"u8);
            writer.WriteObjectValue(RequestMetadata, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExecuteRequestContent IJsonModel<ExecuteRequestContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecuteRequestContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExecuteRequestContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExecuteRequestContent(document.RootElement, options);
        }

        internal static ExecuteRequestContent DeserializeExecuteRequestContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serviceEndpoint = default;
            RequestMetadata requestMetadata = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serviceEndpoint"u8))
                {
                    serviceEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("requestMetadata"u8))
                {
                    requestMetadata = RequestMetadata.DeserializeRequestMetadata(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExecuteRequestContent(serviceEndpoint, requestMetadata, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExecuteRequestContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecuteRequestContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExecuteRequestContent)} does not support writing '{options.Format}' format.");
            }
        }

        ExecuteRequestContent IPersistableModel<ExecuteRequestContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecuteRequestContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExecuteRequestContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExecuteRequestContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExecuteRequestContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
