// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    [PersistableModelProxy(typeof(UnknownDeploymentResourceIdReference))]
    public partial class DeploymentResourceIdReference : IUtf8JsonSerializable, IJsonModel<DeploymentResourceIdReference>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeploymentResourceIdReference>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeploymentResourceIdReference>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentResourceIdReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentResourceIdReference)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("idType"u8);
            writer.WriteStringValue(IdType.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeploymentResourceIdReference IJsonModel<DeploymentResourceIdReference>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentResourceIdReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentResourceIdReference)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeploymentResourceIdReference(document.RootElement, options);
        }

        internal static DeploymentResourceIdReference DeserializeDeploymentResourceIdReference(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("idType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Open": return OpenDeploymentResourceReference.DeserializeOpenDeploymentResourceReference(element, options);
                    case "Secret": return SecretDeploymentResourceReference.DeserializeSecretDeploymentResourceReference(element, options);
                }
            }
            return UnknownDeploymentResourceIdReference.DeserializeUnknownDeploymentResourceIdReference(element, options);
        }

        BinaryData IPersistableModel<DeploymentResourceIdReference>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentResourceIdReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DeploymentResourceIdReference)} does not support writing '{options.Format}' format.");
            }
        }

        DeploymentResourceIdReference IPersistableModel<DeploymentResourceIdReference>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentResourceIdReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeploymentResourceIdReference(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeploymentResourceIdReference)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeploymentResourceIdReference>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
