// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Depends on profile definition. </summary>
    public partial class DependsOnProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DependsOnProfile"/>. </summary>
        public DependsOnProfile()
        {
            InstallDependsOn = new ChangeTrackingList<string>();
            UninstallDependsOn = new ChangeTrackingList<string>();
            UpdateDependsOn = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DependsOnProfile"/>. </summary>
        /// <param name="installDependsOn"> Application installation operation dependency. </param>
        /// <param name="uninstallDependsOn"> Application deletion operation dependency. </param>
        /// <param name="updateDependsOn"> Application update operation dependency. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DependsOnProfile(IList<string> installDependsOn, IList<string> uninstallDependsOn, IList<string> updateDependsOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InstallDependsOn = installDependsOn;
            UninstallDependsOn = uninstallDependsOn;
            UpdateDependsOn = updateDependsOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Application installation operation dependency. </summary>
        public IList<string> InstallDependsOn { get; }
        /// <summary> Application deletion operation dependency. </summary>
        public IList<string> UninstallDependsOn { get; }
        /// <summary> Application update operation dependency. </summary>
        public IList<string> UpdateDependsOn { get; }
    }
}
