// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The component resource deployment status. </summary>
    public readonly partial struct ComponentStatus : IEquatable<ComponentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComponentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComponentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string DeployedValue = "Deployed";
        private const string UninstalledValue = "Uninstalled";
        private const string SupersededValue = "Superseded";
        private const string FailedValue = "Failed";
        private const string UninstallingValue = "Uninstalling";
        private const string PendingInstallValue = "Pending-Install";
        private const string PendingUpgradeValue = "Pending-Upgrade";
        private const string PendingRollbackValue = "Pending-Rollback";
        private const string DownloadingValue = "Downloading";
        private const string InstallingValue = "Installing";
        private const string ReinstallingValue = "Reinstalling";
        private const string RollingbackValue = "Rollingback";
        private const string UpgradingValue = "Upgrading";

        /// <summary> Unknown. </summary>
        public static ComponentStatus Unknown { get; } = new ComponentStatus(UnknownValue);
        /// <summary> Deployed. </summary>
        public static ComponentStatus Deployed { get; } = new ComponentStatus(DeployedValue);
        /// <summary> Uninstalled. </summary>
        public static ComponentStatus Uninstalled { get; } = new ComponentStatus(UninstalledValue);
        /// <summary> Superseded. </summary>
        public static ComponentStatus Superseded { get; } = new ComponentStatus(SupersededValue);
        /// <summary> Failed. </summary>
        public static ComponentStatus Failed { get; } = new ComponentStatus(FailedValue);
        /// <summary> Uninstalling. </summary>
        public static ComponentStatus Uninstalling { get; } = new ComponentStatus(UninstallingValue);
        /// <summary> Pending-Install. </summary>
        public static ComponentStatus PendingInstall { get; } = new ComponentStatus(PendingInstallValue);
        /// <summary> Pending-Upgrade. </summary>
        public static ComponentStatus PendingUpgrade { get; } = new ComponentStatus(PendingUpgradeValue);
        /// <summary> Pending-Rollback. </summary>
        public static ComponentStatus PendingRollback { get; } = new ComponentStatus(PendingRollbackValue);
        /// <summary> Downloading. </summary>
        public static ComponentStatus Downloading { get; } = new ComponentStatus(DownloadingValue);
        /// <summary> Installing. </summary>
        public static ComponentStatus Installing { get; } = new ComponentStatus(InstallingValue);
        /// <summary> Reinstalling. </summary>
        public static ComponentStatus Reinstalling { get; } = new ComponentStatus(ReinstallingValue);
        /// <summary> Rollingback. </summary>
        public static ComponentStatus Rollingback { get; } = new ComponentStatus(RollingbackValue);
        /// <summary> Upgrading. </summary>
        public static ComponentStatus Upgrading { get; } = new ComponentStatus(UpgradingValue);
        /// <summary> Determines if two <see cref="ComponentStatus"/> values are the same. </summary>
        public static bool operator ==(ComponentStatus left, ComponentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComponentStatus"/> values are not the same. </summary>
        public static bool operator !=(ComponentStatus left, ComponentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComponentStatus"/>. </summary>
        public static implicit operator ComponentStatus(string value) => new ComponentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComponentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComponentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
