// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    public partial class ComponentKubernetesResources : IUtf8JsonSerializable, IJsonModel<ComponentKubernetesResources>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ComponentKubernetesResources>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ComponentKubernetesResources>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentKubernetesResources>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ComponentKubernetesResources)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Deployments))
            {
                writer.WritePropertyName("deployments"u8);
                writer.WriteStartArray();
                foreach (var item in Deployments)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Pods))
            {
                writer.WritePropertyName("pods"u8);
                writer.WriteStartArray();
                foreach (var item in Pods)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ReplicaSets))
            {
                writer.WritePropertyName("replicaSets"u8);
                writer.WriteStartArray();
                foreach (var item in ReplicaSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(StatefulSets))
            {
                writer.WritePropertyName("statefulSets"u8);
                writer.WriteStartArray();
                foreach (var item in StatefulSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DaemonSets))
            {
                writer.WritePropertyName("daemonSets"u8);
                writer.WriteStartArray();
                foreach (var item in DaemonSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ComponentKubernetesResources IJsonModel<ComponentKubernetesResources>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentKubernetesResources>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ComponentKubernetesResources)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeComponentKubernetesResources(document.RootElement, options);
        }

        internal static ComponentKubernetesResources DeserializeComponentKubernetesResources(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<KubernetesDeployment> deployments = default;
            IReadOnlyList<KubernetesPod> pods = default;
            IReadOnlyList<KubernetesReplicaSet> replicaSets = default;
            IReadOnlyList<KubernetesStatefulSet> statefulSets = default;
            IReadOnlyList<KubernetesDaemonSet> daemonSets = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deployments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KubernetesDeployment> array = new List<KubernetesDeployment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KubernetesDeployment.DeserializeKubernetesDeployment(item, options));
                    }
                    deployments = array;
                    continue;
                }
                if (property.NameEquals("pods"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KubernetesPod> array = new List<KubernetesPod>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KubernetesPod.DeserializeKubernetesPod(item, options));
                    }
                    pods = array;
                    continue;
                }
                if (property.NameEquals("replicaSets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KubernetesReplicaSet> array = new List<KubernetesReplicaSet>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KubernetesReplicaSet.DeserializeKubernetesReplicaSet(item, options));
                    }
                    replicaSets = array;
                    continue;
                }
                if (property.NameEquals("statefulSets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KubernetesStatefulSet> array = new List<KubernetesStatefulSet>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KubernetesStatefulSet.DeserializeKubernetesStatefulSet(item, options));
                    }
                    statefulSets = array;
                    continue;
                }
                if (property.NameEquals("daemonSets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KubernetesDaemonSet> array = new List<KubernetesDaemonSet>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KubernetesDaemonSet.DeserializeKubernetesDaemonSet(item, options));
                    }
                    daemonSets = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ComponentKubernetesResources(
                deployments ?? new ChangeTrackingList<KubernetesDeployment>(),
                pods ?? new ChangeTrackingList<KubernetesPod>(),
                replicaSets ?? new ChangeTrackingList<KubernetesReplicaSet>(),
                statefulSets ?? new ChangeTrackingList<KubernetesStatefulSet>(),
                daemonSets ?? new ChangeTrackingList<KubernetesDaemonSet>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ComponentKubernetesResources>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentKubernetesResources>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ComponentKubernetesResources)} does not support writing '{options.Format}' format.");
            }
        }

        ComponentKubernetesResources IPersistableModel<ComponentKubernetesResources>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentKubernetesResources>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeComponentKubernetesResources(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ComponentKubernetesResources)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ComponentKubernetesResources>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
