// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The azure storage account credential definition. </summary>
    public partial class AzureStorageAccountCredential : ArtifactAccessCredential
    {
        /// <summary> Initializes a new instance of <see cref="AzureStorageAccountCredential"/>. </summary>
        internal AzureStorageAccountCredential()
        {
            ContainerCredentials = new ChangeTrackingList<AzureStorageAccountContainerCredential>();
            CredentialType = CredentialType.AzureStorageAccountToken;
        }

        /// <summary> Initializes a new instance of <see cref="AzureStorageAccountCredential"/>. </summary>
        /// <param name="credentialType"> The credential type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="storageAccountId"> The storage account Id. </param>
        /// <param name="containerCredentials"> The containers that could be accessed using the current credential. </param>
        /// <param name="expiry"> The UTC time when credential will expire. </param>
        internal AzureStorageAccountCredential(CredentialType credentialType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier storageAccountId, IReadOnlyList<AzureStorageAccountContainerCredential> containerCredentials, DateTimeOffset? expiry) : base(credentialType, serializedAdditionalRawData)
        {
            StorageAccountId = storageAccountId;
            ContainerCredentials = containerCredentials;
            Expiry = expiry;
            CredentialType = credentialType;
        }

        /// <summary> The storage account Id. </summary>
        public ResourceIdentifier StorageAccountId { get; }
        /// <summary> The containers that could be accessed using the current credential. </summary>
        public IReadOnlyList<AzureStorageAccountContainerCredential> ContainerCredentials { get; }
        /// <summary> The UTC time when credential will expire. </summary>
        public DateTimeOffset? Expiry { get; }
    }
}
