// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary>
    /// Azure Operator Distributed Services network function application definition.
    /// Please note <see cref="AzureOperatorNexusNetworkFunctionApplication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AzureOperatorNexusNetworkFunctionArmTemplateApplication"/> and <see cref="AzureOperatorNexusNetworkFunctionImageApplication"/>.
    /// </summary>
    public abstract partial class AzureOperatorNexusNetworkFunctionApplication : NetworkFunctionApplication
    {
        /// <summary> Initializes a new instance of <see cref="AzureOperatorNexusNetworkFunctionApplication"/>. </summary>
        protected AzureOperatorNexusNetworkFunctionApplication()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AzureOperatorNexusNetworkFunctionApplication"/>. </summary>
        /// <param name="name"> The name of the network function application. </param>
        /// <param name="dependsOnProfile"> Depends on profile definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="artifactType"> The artifact type. </param>
        internal AzureOperatorNexusNetworkFunctionApplication(string name, DependsOnProfile dependsOnProfile, IDictionary<string, BinaryData> serializedAdditionalRawData, AzureOperatorNexusArtifactType artifactType) : base(name, dependsOnProfile, serializedAdditionalRawData)
        {
            ArtifactType = artifactType;
        }

        /// <summary> The artifact type. </summary>
        internal AzureOperatorNexusArtifactType ArtifactType { get; set; }
    }
}
