// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The artifact type. </summary>
    internal readonly partial struct AzureOperatorNexusArtifactType : IEquatable<AzureOperatorNexusArtifactType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureOperatorNexusArtifactType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureOperatorNexusArtifactType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ImageFileValue = "ImageFile";
        private const string ArmTemplateValue = "ArmTemplate";

        /// <summary> Unknown. </summary>
        public static AzureOperatorNexusArtifactType Unknown { get; } = new AzureOperatorNexusArtifactType(UnknownValue);
        /// <summary> ImageFile. </summary>
        public static AzureOperatorNexusArtifactType ImageFile { get; } = new AzureOperatorNexusArtifactType(ImageFileValue);
        /// <summary> ArmTemplate. </summary>
        public static AzureOperatorNexusArtifactType ArmTemplate { get; } = new AzureOperatorNexusArtifactType(ArmTemplateValue);
        /// <summary> Determines if two <see cref="AzureOperatorNexusArtifactType"/> values are the same. </summary>
        public static bool operator ==(AzureOperatorNexusArtifactType left, AzureOperatorNexusArtifactType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureOperatorNexusArtifactType"/> values are not the same. </summary>
        public static bool operator !=(AzureOperatorNexusArtifactType left, AzureOperatorNexusArtifactType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureOperatorNexusArtifactType"/>. </summary>
        public static implicit operator AzureOperatorNexusArtifactType(string value) => new AzureOperatorNexusArtifactType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureOperatorNexusArtifactType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureOperatorNexusArtifactType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
