// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The Azure Core NFVI detail. </summary>
    public partial class AzureCoreNfviDetails : NFVIs
    {
        /// <summary> Initializes a new instance of <see cref="AzureCoreNfviDetails"/>. </summary>
        public AzureCoreNfviDetails()
        {
            NfviType = NfviType.AzureCore;
        }

        /// <summary> Initializes a new instance of <see cref="AzureCoreNfviDetails"/>. </summary>
        /// <param name="name"> Name of the nfvi. </param>
        /// <param name="nfviType"> The NFVI type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="location"> Location of the Azure core. </param>
        internal AzureCoreNfviDetails(string name, NfviType nfviType, IDictionary<string, BinaryData> serializedAdditionalRawData, AzureLocation? location) : base(name, nfviType, serializedAdditionalRawData)
        {
            Location = location;
            NfviType = nfviType;
        }

        /// <summary> Location of the Azure core. </summary>
        public AzureLocation? Location { get; set; }
    }
}
