// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The artifact type. </summary>
    internal readonly partial struct AzureCoreArtifactType : IEquatable<AzureCoreArtifactType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureCoreArtifactType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureCoreArtifactType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string VhdImageFileValue = "VhdImageFile";
        private const string ArmTemplateValue = "ArmTemplate";

        /// <summary> Unknown. </summary>
        public static AzureCoreArtifactType Unknown { get; } = new AzureCoreArtifactType(UnknownValue);
        /// <summary> VhdImageFile. </summary>
        public static AzureCoreArtifactType VhdImageFile { get; } = new AzureCoreArtifactType(VhdImageFileValue);
        /// <summary> ArmTemplate. </summary>
        public static AzureCoreArtifactType ArmTemplate { get; } = new AzureCoreArtifactType(ArmTemplateValue);
        /// <summary> Determines if two <see cref="AzureCoreArtifactType"/> values are the same. </summary>
        public static bool operator ==(AzureCoreArtifactType left, AzureCoreArtifactType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureCoreArtifactType"/> values are not the same. </summary>
        public static bool operator !=(AzureCoreArtifactType left, AzureCoreArtifactType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureCoreArtifactType"/>. </summary>
        public static implicit operator AzureCoreArtifactType(string value) => new AzureCoreArtifactType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureCoreArtifactType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureCoreArtifactType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
