// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The azure container registry scoped token credential definition. </summary>
    public partial class AzureContainerRegistryScopedTokenCredential : ArtifactAccessCredential
    {
        /// <summary> Initializes a new instance of <see cref="AzureContainerRegistryScopedTokenCredential"/>. </summary>
        internal AzureContainerRegistryScopedTokenCredential()
        {
            Repositories = new ChangeTrackingList<string>();
            CredentialType = CredentialType.AzureContainerRegistryScopedToken;
        }

        /// <summary> Initializes a new instance of <see cref="AzureContainerRegistryScopedTokenCredential"/>. </summary>
        /// <param name="credentialType"> The credential type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="username"> The username of the credential. </param>
        /// <param name="acrToken"> The credential value. </param>
        /// <param name="acrServerUri"> The Acr server url. </param>
        /// <param name="repositories"> The repositories that could be accessed using the current credential. </param>
        /// <param name="expiry"> The UTC time when credential will expire. </param>
        internal AzureContainerRegistryScopedTokenCredential(CredentialType credentialType, IDictionary<string, BinaryData> serializedAdditionalRawData, string username, string acrToken, Uri acrServerUri, IReadOnlyList<string> repositories, DateTimeOffset? expiry) : base(credentialType, serializedAdditionalRawData)
        {
            Username = username;
            AcrToken = acrToken;
            AcrServerUri = acrServerUri;
            Repositories = repositories;
            Expiry = expiry;
            CredentialType = credentialType;
        }

        /// <summary> The username of the credential. </summary>
        public string Username { get; }
        /// <summary> The credential value. </summary>
        public string AcrToken { get; }
        /// <summary> The Acr server url. </summary>
        public Uri AcrServerUri { get; }
        /// <summary> The repositories that could be accessed using the current credential. </summary>
        public IReadOnlyList<string> Repositories { get; }
        /// <summary> The UTC time when credential will expire. </summary>
        public DateTimeOffset? Expiry { get; }
    }
}
