// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The artifact type. </summary>
    internal readonly partial struct AzureArcKubernetesArtifactType : IEquatable<AzureArcKubernetesArtifactType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureArcKubernetesArtifactType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureArcKubernetesArtifactType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string HelmPackageValue = "HelmPackage";

        /// <summary> Unknown. </summary>
        public static AzureArcKubernetesArtifactType Unknown { get; } = new AzureArcKubernetesArtifactType(UnknownValue);
        /// <summary> HelmPackage. </summary>
        public static AzureArcKubernetesArtifactType HelmPackage { get; } = new AzureArcKubernetesArtifactType(HelmPackageValue);
        /// <summary> Determines if two <see cref="AzureArcKubernetesArtifactType"/> values are the same. </summary>
        public static bool operator ==(AzureArcKubernetesArtifactType left, AzureArcKubernetesArtifactType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureArcKubernetesArtifactType"/> values are not the same. </summary>
        public static bool operator !=(AzureArcKubernetesArtifactType left, AzureArcKubernetesArtifactType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureArcKubernetesArtifactType"/>. </summary>
        public static implicit operator AzureArcKubernetesArtifactType(string value) => new AzureArcKubernetesArtifactType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureArcKubernetesArtifactType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureArcKubernetesArtifactType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
