// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The artifact store type. </summary>
    public readonly partial struct ArtifactStoreType : IEquatable<ArtifactStoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArtifactStoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArtifactStoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string AzureContainerRegistryValue = "AzureContainerRegistry";
        private const string AzureStorageAccountValue = "AzureStorageAccount";

        /// <summary> Unknown. </summary>
        public static ArtifactStoreType Unknown { get; } = new ArtifactStoreType(UnknownValue);
        /// <summary> AzureContainerRegistry. </summary>
        public static ArtifactStoreType AzureContainerRegistry { get; } = new ArtifactStoreType(AzureContainerRegistryValue);
        /// <summary> AzureStorageAccount. </summary>
        public static ArtifactStoreType AzureStorageAccount { get; } = new ArtifactStoreType(AzureStorageAccountValue);
        /// <summary> Determines if two <see cref="ArtifactStoreType"/> values are the same. </summary>
        public static bool operator ==(ArtifactStoreType left, ArtifactStoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArtifactStoreType"/> values are not the same. </summary>
        public static bool operator !=(ArtifactStoreType left, ArtifactStoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArtifactStoreType"/>. </summary>
        public static implicit operator ArtifactStoreType(string value) => new ArtifactStoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArtifactStoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArtifactStoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
