// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The artifact state. </summary>
    public readonly partial struct ArtifactState : IEquatable<ArtifactState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArtifactState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArtifactState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PreviewValue = "Preview";
        private const string ActiveValue = "Active";
        private const string DeprecatedValue = "Deprecated";

        /// <summary> Unknown. </summary>
        public static ArtifactState Unknown { get; } = new ArtifactState(UnknownValue);
        /// <summary> Preview. </summary>
        public static ArtifactState Preview { get; } = new ArtifactState(PreviewValue);
        /// <summary> Active. </summary>
        public static ArtifactState Active { get; } = new ArtifactState(ActiveValue);
        /// <summary> Deprecated. </summary>
        public static ArtifactState Deprecated { get; } = new ArtifactState(DeprecatedValue);
        /// <summary> Determines if two <see cref="ArtifactState"/> values are the same. </summary>
        public static bool operator ==(ArtifactState left, ArtifactState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArtifactState"/> values are not the same. </summary>
        public static bool operator !=(ArtifactState left, ArtifactState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArtifactState"/>. </summary>
        public static implicit operator ArtifactState(string value) => new ArtifactState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArtifactState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArtifactState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
