// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Artifact profile properties. </summary>
    public partial class ArtifactProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArtifactProfile"/>. </summary>
        public ArtifactProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArtifactProfile"/>. </summary>
        /// <param name="artifactStore"> The reference to artifact store. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArtifactProfile(WritableSubResource artifactStore, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArtifactStore = artifactStore;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The reference to artifact store. </summary>
        internal WritableSubResource ArtifactStore { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier ArtifactStoreId
        {
            get => ArtifactStore is null ? default : ArtifactStore.Id;
            set
            {
                if (ArtifactStore is null)
                    ArtifactStore = new WritableSubResource();
                ArtifactStore.Id = value;
            }
        }
    }
}
