// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    [PersistableModelProxy(typeof(UnknownArtifactAccessCredential))]
    public partial class ArtifactAccessCredential : IUtf8JsonSerializable, IJsonModel<ArtifactAccessCredential>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ArtifactAccessCredential>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ArtifactAccessCredential>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArtifactAccessCredential>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ArtifactAccessCredential)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("credentialType"u8);
            writer.WriteStringValue(CredentialType.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ArtifactAccessCredential IJsonModel<ArtifactAccessCredential>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArtifactAccessCredential>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ArtifactAccessCredential)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeArtifactAccessCredential(document.RootElement, options);
        }

        internal static ArtifactAccessCredential DeserializeArtifactAccessCredential(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("credentialType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AzureContainerRegistryScopedToken": return AzureContainerRegistryScopedTokenCredential.DeserializeAzureContainerRegistryScopedTokenCredential(element, options);
                    case "AzureStorageAccountToken": return AzureStorageAccountCredential.DeserializeAzureStorageAccountCredential(element, options);
                }
            }
            return UnknownArtifactAccessCredential.DeserializeUnknownArtifactAccessCredential(element, options);
        }

        BinaryData IPersistableModel<ArtifactAccessCredential>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArtifactAccessCredential>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ArtifactAccessCredential)} does not support writing '{options.Format}' format.");
            }
        }

        ArtifactAccessCredential IPersistableModel<ArtifactAccessCredential>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArtifactAccessCredential>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeArtifactAccessCredential(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ArtifactAccessCredential)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ArtifactAccessCredential>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
