// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> Template artifact profile. </summary>
    public partial class ArmTemplateArtifactProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArmTemplateArtifactProfile"/>. </summary>
        public ArmTemplateArtifactProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArmTemplateArtifactProfile"/>. </summary>
        /// <param name="templateName"> Template name. </param>
        /// <param name="templateVersion"> Template version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArmTemplateArtifactProfile(string templateName, string templateVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TemplateName = templateName;
            TemplateVersion = templateVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Template name. </summary>
        public string TemplateName { get; set; }
        /// <summary> Template version. </summary>
        public string TemplateVersion { get; set; }
    }
}
