// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    public partial class ArmResourceDefinitionResourceElementTemplate : IUtf8JsonSerializable, IJsonModel<ArmResourceDefinitionResourceElementTemplate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ArmResourceDefinitionResourceElementTemplate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ArmResourceDefinitionResourceElementTemplate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArmResourceDefinitionResourceElementTemplate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ArmResourceDefinitionResourceElementTemplate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TemplateType))
            {
                writer.WritePropertyName("templateType"u8);
                writer.WriteStringValue(TemplateType.Value.ToString());
            }
            if (Optional.IsDefined(ParameterValues))
            {
                writer.WritePropertyName("parameterValues"u8);
                writer.WriteStringValue(ParameterValues);
            }
            if (Optional.IsDefined(ArtifactProfile))
            {
                writer.WritePropertyName("artifactProfile"u8);
                writer.WriteObjectValue(ArtifactProfile, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ArmResourceDefinitionResourceElementTemplate IJsonModel<ArmResourceDefinitionResourceElementTemplate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArmResourceDefinitionResourceElementTemplate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ArmResourceDefinitionResourceElementTemplate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeArmResourceDefinitionResourceElementTemplate(document.RootElement, options);
        }

        internal static ArmResourceDefinitionResourceElementTemplate DeserializeArmResourceDefinitionResourceElementTemplate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TemplateType? templateType = default;
            string parameterValues = default;
            NSDArtifactProfile artifactProfile = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("templateType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    templateType = new TemplateType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("parameterValues"u8))
                {
                    parameterValues = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("artifactProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    artifactProfile = NSDArtifactProfile.DeserializeNSDArtifactProfile(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ArmResourceDefinitionResourceElementTemplate(templateType, parameterValues, artifactProfile, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ArmResourceDefinitionResourceElementTemplate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArmResourceDefinitionResourceElementTemplate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ArmResourceDefinitionResourceElementTemplate)} does not support writing '{options.Format}' format.");
            }
        }

        ArmResourceDefinitionResourceElementTemplate IPersistableModel<ArmResourceDefinitionResourceElementTemplate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ArmResourceDefinitionResourceElementTemplate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeArmResourceDefinitionResourceElementTemplate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ArmResourceDefinitionResourceElementTemplate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ArmResourceDefinitionResourceElementTemplate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
