// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridNetwork.Models
{
    /// <summary> The application enablement. </summary>
    public readonly partial struct ApplicationEnablement : IEquatable<ApplicationEnablement>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationEnablement"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationEnablement(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Unknown. </summary>
        public static ApplicationEnablement Unknown { get; } = new ApplicationEnablement(UnknownValue);
        /// <summary> Enabled. </summary>
        public static ApplicationEnablement Enabled { get; } = new ApplicationEnablement(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ApplicationEnablement Disabled { get; } = new ApplicationEnablement(DisabledValue);
        /// <summary> Determines if two <see cref="ApplicationEnablement"/> values are the same. </summary>
        public static bool operator ==(ApplicationEnablement left, ApplicationEnablement right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationEnablement"/> values are not the same. </summary>
        public static bool operator !=(ApplicationEnablement left, ApplicationEnablement right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationEnablement"/>. </summary>
        public static implicit operator ApplicationEnablement(string value) => new ApplicationEnablement(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationEnablement other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationEnablement other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
