// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork
{
    internal class NetworkServiceDesignGroupOperationSource : IOperationSource<NetworkServiceDesignGroupResource>
    {
        private readonly ArmClient _client;

        internal NetworkServiceDesignGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkServiceDesignGroupResource IOperationSource<NetworkServiceDesignGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkServiceDesignGroupData.DeserializeNetworkServiceDesignGroupData(document.RootElement);
            return new NetworkServiceDesignGroupResource(_client, data);
        }

        async ValueTask<NetworkServiceDesignGroupResource> IOperationSource<NetworkServiceDesignGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkServiceDesignGroupData.DeserializeNetworkServiceDesignGroupData(document.RootElement);
            return new NetworkServiceDesignGroupResource(_client, data);
        }
    }
}
