// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork
{
    internal class NetworkFunctionDefinitionVersionOperationSource : IOperationSource<NetworkFunctionDefinitionVersionResource>
    {
        private readonly ArmClient _client;

        internal NetworkFunctionDefinitionVersionOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkFunctionDefinitionVersionResource IOperationSource<NetworkFunctionDefinitionVersionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkFunctionDefinitionVersionData.DeserializeNetworkFunctionDefinitionVersionData(document.RootElement);
            return new NetworkFunctionDefinitionVersionResource(_client, data);
        }

        async ValueTask<NetworkFunctionDefinitionVersionResource> IOperationSource<NetworkFunctionDefinitionVersionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkFunctionDefinitionVersionData.DeserializeNetworkFunctionDefinitionVersionData(document.RootElement);
            return new NetworkFunctionDefinitionVersionResource(_client, data);
        }
    }
}
