// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork
{
    internal class NetworkFunctionDefinitionGroupOperationSource : IOperationSource<NetworkFunctionDefinitionGroupResource>
    {
        private readonly ArmClient _client;

        internal NetworkFunctionDefinitionGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkFunctionDefinitionGroupResource IOperationSource<NetworkFunctionDefinitionGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkFunctionDefinitionGroupData.DeserializeNetworkFunctionDefinitionGroupData(document.RootElement);
            return new NetworkFunctionDefinitionGroupResource(_client, data);
        }

        async ValueTask<NetworkFunctionDefinitionGroupResource> IOperationSource<NetworkFunctionDefinitionGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkFunctionDefinitionGroupData.DeserializeNetworkFunctionDefinitionGroupData(document.RootElement);
            return new NetworkFunctionDefinitionGroupResource(_client, data);
        }
    }
}
