// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork
{
    internal class ConfigurationGroupValueOperationSource : IOperationSource<ConfigurationGroupValueResource>
    {
        private readonly ArmClient _client;

        internal ConfigurationGroupValueOperationSource(ArmClient client)
        {
            _client = client;
        }

        ConfigurationGroupValueResource IOperationSource<ConfigurationGroupValueResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ConfigurationGroupValueData.DeserializeConfigurationGroupValueData(document.RootElement);
            return new ConfigurationGroupValueResource(_client, data);
        }

        async ValueTask<ConfigurationGroupValueResource> IOperationSource<ConfigurationGroupValueResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ConfigurationGroupValueData.DeserializeConfigurationGroupValueData(document.RootElement);
            return new ConfigurationGroupValueResource(_client, data);
        }
    }
}
