// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork
{
    internal class ConfigurationGroupSchemaOperationSource : IOperationSource<ConfigurationGroupSchemaResource>
    {
        private readonly ArmClient _client;

        internal ConfigurationGroupSchemaOperationSource(ArmClient client)
        {
            _client = client;
        }

        ConfigurationGroupSchemaResource IOperationSource<ConfigurationGroupSchemaResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ConfigurationGroupSchemaData.DeserializeConfigurationGroupSchemaData(document.RootElement);
            return new ConfigurationGroupSchemaResource(_client, data);
        }

        async ValueTask<ConfigurationGroupSchemaResource> IOperationSource<ConfigurationGroupSchemaResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ConfigurationGroupSchemaData.DeserializeConfigurationGroupSchemaData(document.RootElement);
            return new ConfigurationGroupSchemaResource(_client, data);
        }
    }
}
