// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridNetwork
{
    internal class ArtifactStoreOperationSource : IOperationSource<ArtifactStoreResource>
    {
        private readonly ArmClient _client;

        internal ArtifactStoreOperationSource(ArmClient client)
        {
            _client = client;
        }

        ArtifactStoreResource IOperationSource<ArtifactStoreResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ArtifactStoreData.DeserializeArtifactStoreData(document.RootElement);
            return new ArtifactStoreResource(_client, data);
        }

        async ValueTask<ArtifactStoreResource> IOperationSource<ArtifactStoreResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ArtifactStoreData.DeserializeArtifactStoreData(document.RootElement);
            return new ArtifactStoreResource(_client, data);
        }
    }
}
