// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.HybridNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="ConfigurationGroupValueResource"/> and their operations.
    /// Each <see cref="ConfigurationGroupValueResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="ConfigurationGroupValueCollection"/> instance call the GetConfigurationGroupValues method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class ConfigurationGroupValueCollection : ArmCollection, IEnumerable<ConfigurationGroupValueResource>, IAsyncEnumerable<ConfigurationGroupValueResource>
    {
        private readonly ClientDiagnostics _configurationGroupValueClientDiagnostics;
        private readonly ConfigurationGroupValuesRestOperations _configurationGroupValueRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConfigurationGroupValueCollection"/> class for mocking. </summary>
        protected ConfigurationGroupValueCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConfigurationGroupValueCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConfigurationGroupValueCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _configurationGroupValueClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.HybridNetwork", ConfigurationGroupValueResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConfigurationGroupValueResource.ResourceType, out string configurationGroupValueApiVersion);
            _configurationGroupValueRestClient = new ConfigurationGroupValuesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, configurationGroupValueApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a hybrid configuration group value.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="data"> Parameters supplied to the create or update configuration group value resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConfigurationGroupValueResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string configurationGroupValueName, ConfigurationGroupValueData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _configurationGroupValueRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, data, cancellationToken).ConfigureAwait(false);
                var operation = new HybridNetworkArmOperation<ConfigurationGroupValueResource>(new ConfigurationGroupValueOperationSource(Client), _configurationGroupValueClientDiagnostics, Pipeline, _configurationGroupValueRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a hybrid configuration group value.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="data"> Parameters supplied to the create or update configuration group value resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConfigurationGroupValueResource> CreateOrUpdate(WaitUntil waitUntil, string configurationGroupValueName, ConfigurationGroupValueData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _configurationGroupValueRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, data, cancellationToken);
                var operation = new HybridNetworkArmOperation<ConfigurationGroupValueResource>(new ConfigurationGroupValueOperationSource(Client), _configurationGroupValueClientDiagnostics, Pipeline, _configurationGroupValueRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified hybrid configuration group values.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> is null. </exception>
        public virtual async Task<Response<ConfigurationGroupValueResource>> GetAsync(string configurationGroupValueName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.Get");
            scope.Start();
            try
            {
                var response = await _configurationGroupValueRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified hybrid configuration group values.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> is null. </exception>
        public virtual Response<ConfigurationGroupValueResource> Get(string configurationGroupValueName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.Get");
            scope.Start();
            try
            {
                var response = _configurationGroupValueRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the hybrid network configurationGroupValues in a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConfigurationGroupValueResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConfigurationGroupValueResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _configurationGroupValueRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _configurationGroupValueRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConfigurationGroupValueResource(Client, ConfigurationGroupValueData.DeserializeConfigurationGroupValueData(e)), _configurationGroupValueClientDiagnostics, Pipeline, "ConfigurationGroupValueCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the hybrid network configurationGroupValues in a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConfigurationGroupValueResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConfigurationGroupValueResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _configurationGroupValueRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _configurationGroupValueRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConfigurationGroupValueResource(Client, ConfigurationGroupValueData.DeserializeConfigurationGroupValueData(e)), _configurationGroupValueClientDiagnostics, Pipeline, "ConfigurationGroupValueCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string configurationGroupValueName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.Exists");
            scope.Start();
            try
            {
                var response = await _configurationGroupValueRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> is null. </exception>
        public virtual Response<bool> Exists(string configurationGroupValueName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.Exists");
            scope.Start();
            try
            {
                var response = _configurationGroupValueRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConfigurationGroupValueResource>> GetIfExistsAsync(string configurationGroupValueName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _configurationGroupValueRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConfigurationGroupValueResource>(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/configurationGroupValues/{configurationGroupValueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupValues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupValueName"> The name of the configuration group value. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupValueName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupValueName"/> is null. </exception>
        public virtual NullableResponse<ConfigurationGroupValueResource> GetIfExists(string configurationGroupValueName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupValueName, nameof(configurationGroupValueName));

            using var scope = _configurationGroupValueClientDiagnostics.CreateScope("ConfigurationGroupValueCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _configurationGroupValueRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, configurationGroupValueName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConfigurationGroupValueResource>(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConfigurationGroupValueResource> IEnumerable<ConfigurationGroupValueResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConfigurationGroupValueResource> IAsyncEnumerable<ConfigurationGroupValueResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
