// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.HybridNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="ConfigurationGroupSchemaResource"/> and their operations.
    /// Each <see cref="ConfigurationGroupSchemaResource"/> in the collection will belong to the same instance of <see cref="PublisherResource"/>.
    /// To get a <see cref="ConfigurationGroupSchemaCollection"/> instance call the GetConfigurationGroupSchemas method from an instance of <see cref="PublisherResource"/>.
    /// </summary>
    public partial class ConfigurationGroupSchemaCollection : ArmCollection, IEnumerable<ConfigurationGroupSchemaResource>, IAsyncEnumerable<ConfigurationGroupSchemaResource>
    {
        private readonly ClientDiagnostics _configurationGroupSchemaClientDiagnostics;
        private readonly ConfigurationGroupSchemasRestOperations _configurationGroupSchemaRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConfigurationGroupSchemaCollection"/> class for mocking. </summary>
        protected ConfigurationGroupSchemaCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConfigurationGroupSchemaCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConfigurationGroupSchemaCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _configurationGroupSchemaClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.HybridNetwork", ConfigurationGroupSchemaResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConfigurationGroupSchemaResource.ResourceType, out string configurationGroupSchemaApiVersion);
            _configurationGroupSchemaRestClient = new ConfigurationGroupSchemasRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, configurationGroupSchemaApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PublisherResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PublisherResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a configuration group schema.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="data"> Parameters supplied to the create or update configuration group schema resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConfigurationGroupSchemaResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string configurationGroupSchemaName, ConfigurationGroupSchemaData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _configurationGroupSchemaRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, data, cancellationToken).ConfigureAwait(false);
                var operation = new HybridNetworkArmOperation<ConfigurationGroupSchemaResource>(new ConfigurationGroupSchemaOperationSource(Client), _configurationGroupSchemaClientDiagnostics, Pipeline, _configurationGroupSchemaRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a configuration group schema.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="data"> Parameters supplied to the create or update configuration group schema resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConfigurationGroupSchemaResource> CreateOrUpdate(WaitUntil waitUntil, string configurationGroupSchemaName, ConfigurationGroupSchemaData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _configurationGroupSchemaRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, data, cancellationToken);
                var operation = new HybridNetworkArmOperation<ConfigurationGroupSchemaResource>(new ConfigurationGroupSchemaOperationSource(Client), _configurationGroupSchemaClientDiagnostics, Pipeline, _configurationGroupSchemaRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified configuration group schema.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> is null. </exception>
        public virtual async Task<Response<ConfigurationGroupSchemaResource>> GetAsync(string configurationGroupSchemaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.Get");
            scope.Start();
            try
            {
                var response = await _configurationGroupSchemaRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupSchemaResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified configuration group schema.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> is null. </exception>
        public virtual Response<ConfigurationGroupSchemaResource> Get(string configurationGroupSchemaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.Get");
            scope.Start();
            try
            {
                var response = _configurationGroupSchemaRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupSchemaResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information of the configuration group schemas under a publisher.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_ListByPublisher</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConfigurationGroupSchemaResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConfigurationGroupSchemaResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _configurationGroupSchemaRestClient.CreateListByPublisherRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _configurationGroupSchemaRestClient.CreateListByPublisherNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConfigurationGroupSchemaResource(Client, ConfigurationGroupSchemaData.DeserializeConfigurationGroupSchemaData(e)), _configurationGroupSchemaClientDiagnostics, Pipeline, "ConfigurationGroupSchemaCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets information of the configuration group schemas under a publisher.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_ListByPublisher</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConfigurationGroupSchemaResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConfigurationGroupSchemaResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _configurationGroupSchemaRestClient.CreateListByPublisherRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _configurationGroupSchemaRestClient.CreateListByPublisherNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConfigurationGroupSchemaResource(Client, ConfigurationGroupSchemaData.DeserializeConfigurationGroupSchemaData(e)), _configurationGroupSchemaClientDiagnostics, Pipeline, "ConfigurationGroupSchemaCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string configurationGroupSchemaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.Exists");
            scope.Start();
            try
            {
                var response = await _configurationGroupSchemaRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> is null. </exception>
        public virtual Response<bool> Exists(string configurationGroupSchemaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.Exists");
            scope.Start();
            try
            {
                var response = _configurationGroupSchemaRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConfigurationGroupSchemaResource>> GetIfExistsAsync(string configurationGroupSchemaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _configurationGroupSchemaRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConfigurationGroupSchemaResource>(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupSchemaResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationGroupSchemas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConfigurationGroupSchemaResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationGroupSchemaName"> The name of the configuration group schema. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationGroupSchemaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationGroupSchemaName"/> is null. </exception>
        public virtual NullableResponse<ConfigurationGroupSchemaResource> GetIfExists(string configurationGroupSchemaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationGroupSchemaName, nameof(configurationGroupSchemaName));

            using var scope = _configurationGroupSchemaClientDiagnostics.CreateScope("ConfigurationGroupSchemaCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _configurationGroupSchemaRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationGroupSchemaName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConfigurationGroupSchemaResource>(response.GetRawResponse());
                return Response.FromValue(new ConfigurationGroupSchemaResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConfigurationGroupSchemaResource> IEnumerable<ConfigurationGroupSchemaResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConfigurationGroupSchemaResource> IAsyncEnumerable<ConfigurationGroupSchemaResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
